:-module(ruleChoices,[findR/3]).

:-use_module(helperFunctions).
:-use_module(library(lists)).
:-use_module(library(random)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% CHOICE OF RULE, decides which of potentially multiple matching rules are use by the prop %%%
%%% Only used in case 1(ii) ... and only rules considered which do not already have culprits %%%
%%% First two args: input Omega and previous culprits ... third arg: output RHS of rule      %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

findR(Omega,C,RHS)	:-
		user:rule_choice(X),
		selectRule(X,Omega,C,RHS).

%%% pick the first matching rule according to input order
selectRule(1,Omega,C,R)	:- 	myRule(Omega,R), intersectLists(C,R,[]).

%%% prefer the rule with fewest assumptions on the RHS
selectRule(2,Omega,C,ROut) 	:-	findall(R, (myRule(Omega,R), intersectLists(C,R,[])), ListOfRHSs),
				sortByLengthOfAssMemberLists(ListOfRHSs,[ROut|_]).

%%% prefer the rule with fewest elements on the RHS
selectRule(3,Omega,C,ROut) 	:-	findall(R, (myRule(Omega,R), intersectLists(C,R,[])), ListOfRHSs),
				sortByLengthOfMemberLists(ListOfRHSs,[ROut|_]).

%%% pick a rule at random
selectRule(4,Omega,C,ROut) 	:-	findall(R, (myRule(Omega,R), intersectLists(C,R,[])), ListOfRHSs),
				length(ListOfRHSs, Len), Len1 is Len + 1,
				random(1,Len1,Ran),
				nth(Ran,ListOfRHSs,ROut).

myRule(X,Y) :- user:myRule(X,Y).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sortByLengthOfMemberLists(ListOfRHSs, Sorted) :- bsort(ListOfRHSs, Sorted).

bsort(L,S) :-append(X,[A,B|Y],L),length(A,AL),length(B,BL),BL < AL,append(X,[B,A|Y],M),!,bsort(M,S).
bsort(L,L).

sortByLengthOfAssMemberLists(ListOfRHSs, Sorted) :- bsortAsm(ListOfRHSs, Sorted).

bsortAsm(L,S) 	:-	append(X,[A,B|Y],L),
			countAssumptions(A,NumA), countAssumptions(B,NumB),	
			NumB < NumA, append(X,[B,A|Y],M),
			!, bsortAsm(M,S).
bsortAsm(L,L).

countAssumptions([],0).
countAssumptions([H|T],Sum) :- \+ myAsm(H), countAssumptions(T,Sum).
countAssumptions([H|T],Sum) :- myAsm(H), countAssumptions(T,SumPart), Sum is SumPart + 1.
